/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.algorithms.BubbleJoinIterator;
import cz.insophy.inplan.planning.algorithms.Direction;
import cz.insophy.inplan.planning.algorithms.RmFilteredWpIterator;
import cz.insophy.inplan.planning.mokos.AbstractPositioner;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class RebuildPlannerUtils {
    private RebuildPlannerUtils() {
    }

    public static List<ActivityChange> fixAndRegister(Plan plan) {
        Tuple<List<ActivityChange>, List<ActivityChange>> sepChanges = RebuildPlannerUtils.fix(plan);
        plan.registerChanges(sepChanges.getFirst());
        plan.registerChanges(sepChanges.getSecond());
        ArrayList<ActivityChange> changes = Lists.newArrayList();
        changes.addAll((Collection)sepChanges.getFirst());
        changes.addAll((Collection)sepChanges.getSecond());
        return changes;
    }

    public static Tuple<List<ActivityChange>, List<ActivityChange>> fix(Plan plan) {
        Tuple<List<Rebuild>, List<Rebuild>> sepChanges = RebuildPlannerUtils.fix2(plan);
        List<ActivityChange> deletions = RebuildPlannerUtils.extractChanges(sepChanges.getFirst(), ActivityChange.ChangeType.REMOVED);
        List<ActivityChange> additions = RebuildPlannerUtils.extractChanges(sepChanges.getSecond(), ActivityChange.ChangeType.ADDED);
        return Tuple.create(deletions, additions);
    }

    public static Tuple<List<Rebuild>, List<Rebuild>> fix2(Plan plan) {
        ArrayList<Rebuild> deletions = Lists.newArrayList();
        ArrayList<Rebuild> additions = Lists.newArrayList();
        StoreSchedule ss = plan.getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        for (WorkplaceSchedule wps : plan.getWorkplaceSchedules()) {
            RebuidlDeletor rebuidlDeletor = new RebuidlDeletor();
            List<Rebuild> removedRebs = rebuidlDeletor.removeBadRebuilds(wps);
            HashSet<RebuildActivity> remRebSet = Sets.newHashSet(RebuildPlannerUtils.extractActivities(removedRebs));
            RebuildsCreator rebuildsCreator = new RebuildsCreator();
            List<Rebuild> addedRebs = rebuildsCreator.addMissingRebuilds(wps, ss, remRebSet);
            deletions.addAll(removedRebs);
            additions.addAll(addedRebs);
        }
        return Tuple.create(deletions, additions);
    }

    private static List<RebuildActivity> extractActivities(List<Rebuild> rebuildChs) {
        ArrayList<RebuildActivity> ras = Lists.newArrayList();
        for (Rebuild reb : rebuildChs) {
            ras.addAll(reb);
        }
        return ras;
    }

    private static List<ActivityChange> extractChanges(List<Rebuild> rebuildChs, ActivityChange.ChangeType chtype) {
        List<RebuildActivity> ras = RebuildPlannerUtils.extractActivities(rebuildChs);
        ArrayList<ActivityChange> chs = Lists.newArrayList();
        for (RebuildActivity ra : ras) {
            chs.add(new ActivityChange(ra, chtype));
        }
        return chs;
    }

    private static String getRebType(WorkplaceActivity wa) {
        Set<ActionActivity> aas;
        Action act = null;
        if (wa instanceof ActionActivity) {
            act = ((ActionActivity)wa).getAction();
        } else if (wa instanceof CumulativeWorkplaceActivity && !(aas = ((CumulativeWorkplaceActivity)wa).getActionActivities()).isEmpty()) {
            act = aas.iterator().next().getAction();
        }
        String rt = null;
        if (act != null) {
            rt = act.getRebuildType();
        }
        return rt;
    }

    private static class RebuidlDeletor {
        private final List<Rebuild> changes = new ArrayList<Rebuild>();
        private Rebuild lastReb = null;
        private long connectTime = Long.MIN_VALUE;
        private RebuildType currentRt = null;

        public List<Rebuild> removeBadRebuilds(WorkplaceSchedule wps) {
            Workplace wp = wps.getWorkplace();
            Iterator<WorkplaceActivity> it = wps.forwardIterator();
            while (it.hasNext()) {
                String rtName;
                WorkplaceActivity wa = it.next();
                if (this.lastReb != null) {
                    if (this.connectTime != wa.getStart()) {
                        this.flush(false);
                    } else if (wa instanceof RebuildActivity) {
                        RebuildType lastRt = this.lastReb.getRt();
                        if (lastRt != (rt = ((RebuildActivity)wa).getToType())) {
                            this.flush(false);
                        }
                    } else if (wa instanceof OfflineActivity) {
                        this.connectTime = wa.getEnd();
                    } else if (wa instanceof ActionActivity || wa instanceof CumulativeWorkplaceActivity) {
                        rtName = RebuildPlannerUtils.getRebType(wa);
                        rt = this.lastReb.getRt();
                        boolean sameRt = (rt == null || rt.getName() == null) && rtName == null || rt != null && rt.getName().equals(rtName);
                        boolean needed = rt != this.currentRt;
                        this.flush(sameRt && needed);
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                if (wa instanceof RebuildActivity) {
                    if (this.lastReb == null) {
                        this.lastReb = new Rebuild(wp, wa.getStart());
                    }
                    this.lastReb.add((RebuildActivity)wa);
                    this.connectTime = wa.getEnd();
                    continue;
                }
                if (!(wa instanceof ActionActivity) && !(wa instanceof CumulativeWorkplaceActivity)) continue;
                rtName = RebuildPlannerUtils.getRebType(wa);
                this.currentRt = rtName != null ? wps.getWorkplace().getRebuildType(rtName) : null;
            }
            if (this.lastReb != null) {
                this.flush(false);
            }
            return this.changes;
        }

        private void flush(boolean ok) {
            if (!ok) {
                this.changes.add(this.lastReb);
            }
            this.lastReb = null;
            this.connectTime = Long.MIN_VALUE;
        }
    }

    private static class RebuildsCreator {
        private final List<Rebuild> changes = Lists.newArrayList();
        private RebuildType currentRt = null;

        public List<Rebuild> addMissingRebuilds(WorkplaceSchedule wps, StoreSchedule ss, Set<RebuildActivity> removedRebs) {
            Workplace wp = wps.getWorkplace();
            BubbleJoinIterator it = new BubbleJoinIterator(new RmFilteredWpIterator(removedRebs, wps.forwardIteratorWithBubbles(Long.MIN_VALUE, true), Long.MIN_VALUE, Direction.FORWARD));
            while (it.hasNext()) {
                WorkplaceActivity wa = (WorkplaceActivity)it.next();
                if (wa instanceof ActionActivity || wa instanceof CumulativeWorkplaceActivity) {
                    String rtName = RebuildPlannerUtils.getRebType(wa);
                    RebuildType rt = wp.getRebuildType(rtName);
                    if (rt == null || rt == this.currentRt) continue;
                    long raStart = AbstractPositioner.findRaStart(wps, removedRebs, wa.getStart(), Long.MIN_VALUE, rt, rt.getTime());
                    AbstractPositioner.PositioningReport report = AbstractPositioner.positionRaFrom(wps, removedRebs, ss, raStart, rt, rt.getTime(), false);
                    Rebuild newReb = new Rebuild(wp, raStart);
                    for (ActivityChange ac : report.getActChanges()) {
                        newReb.add((RebuildActivity)ac.getActivity());
                    }
                    this.changes.add(newReb);
                    this.currentRt = rt;
                    continue;
                }
                if (wa instanceof RebuildActivity) {
                    this.currentRt = ((RebuildActivity)wa).getToType();
                    continue;
                }
                if (wa instanceof OfflineActivity || wa instanceof Bubble) continue;
                throw new IllegalArgumentException();
            }
            return this.changes;
        }
    }

    public static class Rebuild
    implements Collection<RebuildActivity> {
        private final Workplace wp;
        private final long expectedStart;
        private final List<RebuildActivity> ras;
        private RebuildType rt;
        private long rebLength;
        private long end;

        public Rebuild(Workplace wp, long expectedStart) {
            this.wp = wp;
            this.end = Long.MIN_VALUE;
            this.rebLength = 0L;
            this.ras = Lists.newArrayList();
            this.expectedStart = expectedStart;
        }

        public Workplace getWp() {
            return this.wp;
        }

        public RebuildType getRt() {
            return this.rt;
        }

        public long getExpectedStart() {
            return this.expectedStart;
        }

        public long getEnd() {
            return this.end;
        }

        public long getRebLength() {
            return this.rebLength;
        }

        @Override
        public boolean isEmpty() {
            return this.ras.isEmpty();
        }

        public int raCount() {
            return this.ras.size();
        }

        @Override
        public boolean add(RebuildActivity ra) {
            RebuildType rt = ra.getToType();
            if (this.rt != null) {
                Preconditions.checkArgument(rt == this.rt);
            } else {
                this.rt = rt;
            }
            this.ras.add(ra);
            this.rebLength += ra.getDuration();
            if (ra.getEnd() > this.end) {
                this.end = ra.getEnd();
            }
            return true;
        }

        @Override
        public Iterator<RebuildActivity> iterator() {
            return this.ras.iterator();
        }

        @Override
        public int size() {
            return this.ras.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.ras.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.ras.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends RebuildActivity> c) {
            for (RebuildActivity rebuildActivity : c) {
                this.add(rebuildActivity);
            }
            return !c.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.ras.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.ras.toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

